<?php
namespace Admin;

class AuthController extends \Controller
{
  public function showLogin(): void
  {
    \Session::start();

    // kalau sudah login, langsung ke dashboard
    if (\Session::has('admin_id')) {
      $this->redirect('/admin');
    }

    $error = \Session::flash('error');
    $this->render('admin/auth/login', ['error' => $error], 'admin');
  }

  public function login(): void
  {
    \Session::start();

    $username = trim((string)\Request::post('username', ''));
    $password = (string)\Request::post('password', '');

    if ($username === '' || $password === '') {
      \Session::flash('error', 'Username dan password wajib diisi.');
      $this->redirect('/admin/login');
    }

    $pdo = \Database::pdo();
    $stmt = $pdo->prepare("SELECT * FROM admin_users WHERE username = :u LIMIT 1");
    $stmt->execute(['u' => $username]);
    $admin = $stmt->fetch();

    if (!$admin || (int)$admin['is_active'] !== 1) {
      \Session::flash('error', 'Akun tidak ditemukan / nonaktif.');
      $this->redirect('/admin/login');
    }

    if (!password_verify($password, $admin['password_hash'])) {
      \Session::flash('error', 'Username atau password salah.');
      $this->redirect('/admin/login');
    }

    \Session::set('admin_id', (int)$admin['id']);
    \Session::set('admin_name', (string)$admin['name']);

    $redirect = \Session::flash('redirect_after_login') ?: '/admin';
    $this->redirect($redirect);
  }

  public function logout(): void
  {
    \Session::start();
    \Session::destroy();
    $this->redirect('/admin/login');
  }
}
