<?php

class Controller
{
  protected function render(string $view, array $data = [], string $layout = 'main'): void
  {
    extract($data);
    $viewFile = __DIR__ . '/../views/' . $view . '.php';
    $layoutFile = __DIR__ . '/../views/layouts/' . $layout . '.php';

    ob_start();
    require $viewFile;
    $content = ob_get_clean();

    require $layoutFile;
  }

  protected function redirect(string $to): void
  {
    header('Location: ' . $to);
    exit;
  }
}
