<?php

class Router
{
  private array $routes = [];

  public function get(string $path, callable|array $handler, array $middlewares = []): void
  {
    $this->map('GET', $path, $handler, $middlewares);
  }

  public function post(string $path, callable|array $handler, array $middlewares = []): void
  {
    $this->map('POST', $path, $handler, $middlewares);
  }

  private function map(string $method, string $path, callable|array $handler, array $middlewares): void
  {
    $this->routes[$method][$path] = [
      'handler' => $handler,
      'middlewares' => $middlewares,
    ];
  }

  public function dispatch(string $method, string $path): void
  {
    $method = strtoupper($method);

    $route = $this->routes[$method][$path] ?? null;

    if (!$route) {
      http_response_code(404);
      echo "404 Not Found";
      return;
    }

    // middlewares
    foreach ($route['middlewares'] as $mw) {
      if (is_string($mw) && method_exists($mw, 'handle')) {
        $mw::handle();
      }
    }

    $handler = $route['handler'];

    // Controller@method
    if (is_array($handler) && count($handler) === 2) {
      [$class, $action] = $handler;
      $controller = new $class();
      $controller->$action();
      return;
    }

    // Callable
    if (is_callable($handler)) {
      $handler();
      return;
    }

    throw new Exception('Invalid route handler');
  }
}
