<?php
// Auth layout (login/standalone)
// Variables expected:
// - $branding (array)
// - $page_title (string)
// - $styles (array)
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title><?= e(($branding['title'] ?? 'RAJAWALI') . ($page_title ? ' — ' . $page_title : '')) ?></title>

  <link rel="icon" type="image/png" sizes="32x32" href="<?= e($branding['favicon_url'] ?? asset_url('img/favicon-32.png')) ?>">

  <?php $assetVer = (string)@filemtime(APP_ROOT . '/assets/css/global.css'); ?>
  <link rel="icon" type="image/png" sizes="16x16" href="<?= e($branding['favicon_url'] ?? asset_url('img/favicon-16.png')) ?>">

  <link rel="stylesheet" href="<?= e(asset_url('css/global.css?v=' . $assetVer)) ?>">
  <?php foreach (($styles ?? []) as $css): ?>
    <link rel="stylesheet" href="<?= e(asset_url('css/' . ltrim((string)$css, '/'))) ?>">
  <?php endforeach; ?>

  <style>
    :root{
      --brand-primary: <?= e($branding['primary'] ?? '#b00000') ?>;
      --sidebar-bg: <?= e($branding['sidebar_bg'] ?? '#ffffff') ?>;
      --topbar-bg: <?= e($branding['topbar_bg'] ?? '#b00000') ?>;
    }
  </style>
</head>
<body class="auth-body">
