<?php
// Variables expected:
// - $branding (array)
// - $page_title (string)
// - $breadcrumb_html (string)
// - $view_file (string)
// - $styles (array) optional
$faviconUrl = (string)($branding['favicon_url'] ?? asset_url('img/favicon-32.png'));
$faviconExt = strtolower(pathinfo(parse_url($faviconUrl, PHP_URL_PATH) ?? '', PATHINFO_EXTENSION));
$faviconType = $faviconExt === 'ico' ? 'image/x-icon' : 'image/png';
$assetVer = (string)@filemtime(APP_ROOT . '/assets/css/global.css');
$jsVer = (string)@filemtime(APP_ROOT . '/assets/js/app.js');
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title><?= e(($branding['title'] ?? 'RAJAWALI') . ($page_title ? ' — ' . $page_title : '')) ?></title>

  <link rel="icon" type="<?= e($faviconType) ?>" href="<?= e($faviconUrl) ?>">
  <link rel="icon" type="image/png" sizes="32x32" href="<?= e($faviconUrl) ?>">
  <link rel="icon" type="image/png" sizes="16x16" href="<?= e($faviconUrl) ?>">

  <link rel="stylesheet" href="<?= e(asset_url('css/global.css?v=' . $assetVer)) ?>">
  <?php foreach (($styles ?? []) as $css): ?>
    <link rel="stylesheet" href="<?= e(asset_url('css/' . ltrim((string)$css, '/'))) ?>">
  <?php endforeach; ?>

  <style>
    :root{
      --brand-primary: <?= e($branding['primary'] ?? '#b00000') ?>;
      --sidebar-bg: <?= e($branding['sidebar_bg'] ?? '#ffffff') ?>;
      --topbar-bg: <?= e($branding['topbar_bg'] ?? '#b00000') ?>;
    }
  </style>
</head>
<body class="app">
  <div class="app-shell">
    <div class="sidebar-backdrop" id="sidebarBackdrop" aria-hidden="true"></div>
