<?php
$current = current_path();
$sidebarState = (string)($_COOKIE['sidebar_state'] ?? 'expanded');
if (!in_array($sidebarState, ['expanded','collapsed'], true)) {
  $sidebarState = 'expanded';
}

$locationName = (string)($branding['location_name'] ?? '');
?>
<aside class="app-sidebar" data-state="<?= e($sidebarState) ?>">
  <div class="sidebar-header">
    <a class="brand" href="<?= e(base_url('/dashboard')) ?>">
      <img class="brand-logo" src="<?= e($branding['logo_url'] ?? asset_url('img/logo-placeholder.svg')) ?>" alt="Logo">
      <span class="brand-text"><?= e($branding['brand_name'] ?? 'RAJAWALI') ?></span>
    </a>
  </div>

  <nav class="sidebar-nav" aria-label="Main navigation">
    <div class="nav-group">
      <div class="nav-group-title">MAIN</div>

      <?php if (can('dashboard.view')): ?>
      <a class="nav-link <?= $current === '/dashboard' ? 'active' : '' ?>" href="<?= e(base_url('/dashboard')) ?>">
        <span class="nav-ico" aria-hidden="true">🏠</span>
        <span class="nav-text">Dashboard</span>
      </a>
      <?php endif; ?>

      <?php if (can('pos.view')): ?>
      <a class="nav-link <?= str_starts_with($current, '/pos') ? 'active' : '' ?>" href="<?= e(base_url('/pos')) ?>" title="Placeholder (Sprint 4)">
        <span class="nav-ico" aria-hidden="true">🧾</span>
        <span class="nav-text">POS Order</span>
      </a>
      <?php endif; ?>
    </div>

    <?php if (can('settings.locations.view') || can('settings.branding.view') || can('settings.users.view') || can('settings.roles.view')): ?>
      <div class="nav-group">
        <div class="nav-group-title">SETTINGS</div>

        <?php if (can('settings.locations.view')): ?>
          <a class="nav-link <?= $current === '/settings/locations' ? 'active' : '' ?>" href="<?= e(base_url('/settings/locations')) ?>">
            <span class="nav-ico" aria-hidden="true">📍</span>
            <span class="nav-text">Lokasi Bisnis</span>
          </a>
        <?php endif; ?>

        <?php if (can('settings.branding.view')): ?>
          <a class="nav-link <?= $current === '/settings/branding' ? 'active' : '' ?>" href="<?= e(base_url('/settings/branding')) ?>">
            <span class="nav-ico" aria-hidden="true">🎨</span>
            <span class="nav-text">Branding</span>
          </a>
        <?php endif; ?>

        <?php if (can('settings.users.view')): ?>
          <a class="nav-link <?= $current === '/settings/users' ? 'active' : '' ?>" href="<?= e(base_url('/settings/users')) ?>">
            <span class="nav-ico" aria-hidden="true">👤</span>
            <span class="nav-text">Users</span>
          </a>
        <?php endif; ?>

        <?php if (can('settings.roles.view')): ?>
          <a class="nav-link <?= $current === '/settings/roles' ? 'active' : '' ?>" href="<?= e(base_url('/settings/roles')) ?>">
            <span class="nav-ico" aria-hidden="true">🛡️</span>
            <span class="nav-text">Roles & Permissions</span>
          </a>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <div class="nav-group">
      <div class="nav-group-title">TOOLS</div>

      <a class="nav-link" href="<?= e(base_url('/health')) ?>" target="_blank" rel="noreferrer">
        <span class="nav-ico" aria-hidden="true">✅</span>
        <span class="nav-text">Health</span>
      </a>
    </div>
  </nav>
</aside>

<div class="app-main">
  <header class="app-topbar">
    <button id="sidebarToggle" class="btn-icon" aria-label="Toggle sidebar" type="button">☰</button>

    <div class="topbar-right">
      <?php if (can('pos.view')): ?>
        <a class="btn btn-light btn-pill" href="<?= e(base_url('/pos')) ?>">POS ORDER</a>
      <?php endif; ?>

      <div class="topbar-meta" aria-label="Date time">
        <div class="topbar-meta-date"><?= e(date('d/m/Y')) ?></div>
        <div class="topbar-meta-time"><?= e(date('H.i.s')) ?></div>
      </div>

      <?php
        $locOptions = session_get('location_options', []);
        if (!is_array($locOptions)) $locOptions = [];

        $userName = (string)session_get('user_name', 'User');
        $roleCode = current_role_label();
        $avatarUrl = (string)session_get('user_avatar_url', '');
        $initial = user_initials($userName);
      ?>

      <?php if (session_get('user_id')): ?>
        <div class="user-menu" id="userMenu">
          <button class="user-menu-trigger" id="userMenuBtn" type="button" aria-haspopup="true" aria-expanded="false">
            <span class="user-avatar" aria-hidden="true">
              <?php if ($avatarUrl !== ''): ?>
                <img src="<?= e($avatarUrl) ?>" alt="Avatar">
              <?php else: ?>
                <span class="user-avatar-initial"><?= e($initial) ?></span>
              <?php endif; ?>
            </span>
            <span class="user-meta">
              <span class="user-name"><?= e($userName) ?></span>
              <span class="user-role"><?= e(role_label($roleCode)) ?></span>
            </span>
            <span class="user-caret" aria-hidden="true">▾</span>
          </button>

          <div class="user-dropdown" id="userMenuDropdown" role="menu" aria-label="User menu">
            <div class="dropdown-section">
              <div class="dropdown-label">Lokasi</div>
              <?php if (count($locOptions) > 1): ?>
                <form method="post" action="<?= e(base_url('/switch-location')) ?>" style="margin:0">
                  <select name="location_id" onchange="this.form.submit()" style="width:100%">
                    <?php $activeId = (int)session_get('location_id', 0); ?>
                    <?php foreach ($locOptions as $opt): ?>
                      <option value="<?= e((string)$opt['id']) ?>" <?= ((int)$opt['id'] === $activeId) ? 'selected' : '' ?>><?= e((string)$opt['name']) ?></option>
                    <?php endforeach; ?>
                  </select>
                </form>
              <?php else: ?>
                <div class="dropdown-value"><?= e($locationName !== '' ? $locationName : '—') ?></div>
              <?php endif; ?>
            </div>

            <a class="dropdown-item" href="<?= e(base_url('/profile')) ?>" role="menuitem">Profil Saya</a>

            <form action="<?= e(base_url('/logout')) ?>" method="post" style="margin:0">
              <button class="dropdown-item logout" type="submit" role="menuitem">Logout</button>
            </form>
          </div>
        </div>
      <?php else: ?>
        <a class="btn" href="<?= e(base_url('/login')) ?>">Login</a>
      <?php endif; ?>
    </div>
  </header>

  <main class="app-content">
    <div class="app-breadcrumb"><?= $breadcrumb_html ?? '' ?></div>

    <section class="page-inner">
      <div class="page-head">
        <h1><?= e((string)($page_title ?? '')) ?></h1>
        <div class="page-actions">
          <!-- per-page actions -->
        </div>
      </div>

      <div class="page-body">
        <?php require $view_file; ?>
      </div>
    </section>
  </main>

  <footer class="app-footer"><?= e((string)($branding['footer_text'] ?? '')) ?></footer>
</div>
