<?php
declare(strict_types=1);

namespace App\Controllers;

require_once APP_PATH . '/helpers/url_helper.php';
require_once APP_PATH . '/helpers/db.php';
require_once APP_PATH . '/helpers/auth_helper.php';

class AuthController
{
  public function showLogin(): void
  {
    require APP_PATH . '/views/auth/login.php';
  }

  public function login(): void
  {
    $email = trim((string)($_POST['email'] ?? ''));
    $pass  = (string)($_POST['password'] ?? '');

    if ($email === '' || $pass === '') {
      $_SESSION['flash_error'] = 'Email dan password wajib diisi.';
      header('Location: ' . url('/login'));
      exit;
    }

    // Sprint 2 Patch 2: login via DB
    $tenantId = (int)($_SESSION['tenant_id'] ?? 1);

    // Rate limit sederhana (5x gagal -> lock 5 menit)
    $key = 'login_fail:' . md5($tenantId . '|' . strtolower($email));
    $fails = (int)($_SESSION[$key]['count'] ?? 0);
    $lockedUntil = (int)($_SESSION[$key]['locked_until'] ?? 0);
    if ($lockedUntil > time()) {
      $_SESSION['flash_error'] = 'Terlalu banyak percobaan gagal. Coba lagi beberapa menit lagi.';
      header('Location: ' . url('/login'));
      exit;
    }

    $st = db()->prepare('SELECT id, tenant_id, name, email, thumbnail, password_hash, is_active, is_owner FROM users WHERE tenant_id=? AND email=? LIMIT 1');

    $st->execute([$tenantId, $email]);
    $u = $st->fetch();

    $ok = false;
    if ($u && (int)($u['is_active'] ?? 0) === 1) {
      $ok = password_verify($pass, (string)$u['password_hash']);
    }

    if ($ok) {
      // reset rate limit
      unset($_SESSION[$key]);

      $_SESSION['user_id'] = (int)$u['id'];
$_SESSION['tenant_id'] = (int)$u['tenant_id'];
$_SESSION['user_name'] = (string)$u['name'];
$_SESSION['user_email'] = (string)$u['email'];
$_SESSION['user_thumb'] = (string)($u['thumbnail'] ?? '');
$_SESSION['is_owner'] = (int)($u['is_owner'] ?? 0);
      unset($_SESSION['_perm_cache']);

      // set lokasi aktif (single asking: jika user punya 1 lokasi -> auto)
      $st2 = db()->prepare('SELECT location_id FROM user_locations ul JOIN locations l ON l.id=ul.location_id WHERE ul.user_id=? AND l.tenant_id=? AND l.is_active=1');
      $st2->execute([(int)$u['id'], $tenantId]);
      $locs = $st2->fetchAll();
      if (count($locs) === 1) {
        $_SESSION['location_id'] = (int)$locs[0]['location_id'];
      } elseif (!empty($_SESSION['location_id'])) {
        // keep existing if still allowed
        $allowed = array_map(fn($r) => (int)$r['location_id'], $locs);
        if (!in_array((int)$_SESSION['location_id'], $allowed, true)) {
          $_SESSION['location_id'] = !empty($allowed) ? (int)$allowed[0] : 1;
        }
      } else {
        $_SESSION['location_id'] = !empty($locs) ? (int)$locs[0]['location_id'] : 1;
      }

      header('Location: ' . url('/dashboard'));
      exit;
    }

    // bump fails
    $fails++;
    $_SESSION[$key]['count'] = $fails;
    if ($fails >= 5) {
      $_SESSION[$key]['locked_until'] = time() + (5 * 60);
    }

    $_SESSION['flash_error'] = 'Login gagal. Cek email/password.';
    header('Location: ' . url('/login'));
    exit;
  }

  public function logout(): void
  {
    unset($_SESSION['user_id']);
   unset($_SESSION['user_name'], $_SESSION['user_email'], $_SESSION['user_thumb'], $_SESSION['is_owner'], $_SESSION['_perm_cache']);

    // biarkan tenant/location tetap? atau reset? ini prefer:
    // unset($_SESSION['tenant_id'], $_SESSION['location_id']);

    header('Location: ' . url('/login'));
    exit;
  }
}
