<?php
declare(strict_types=1);

namespace App\Controllers;

class DashboardController {
  public function index(): void {

    $pageTitle = 'Dashboard';
    $breadcrumb = [
      ['label' => 'Home', 'url' => url('/dashboard')],
      ['label' => 'Dashboard', 'url' => null],
    ];

    // cukup render 1 view (view ini include header+footer)
    view('dashboard/index.php', [
      'pageTitle'  => $pageTitle,
      'breadcrumb' => $breadcrumb,
      'bodyClass'  => 'app theme-light',
      'activeMenu' => 'dashboard',
      // optional: kalau mau override nama brand (kalau tidak, header.php sudah set dari identity)
      // 'brandName'  => 'printfreight',
    ]);
  }
}
