<?php
declare(strict_types=1);

namespace App\Controllers\Settings;

require_once APP_PATH . '/helpers/auth_helper.php';
require_once APP_PATH . '/services/LicenseService.php';
require_once APP_PATH . '/models/Location.php';

class LocationController {

  private function guard(): void {
    require_permission('settings.view');
  }

  public function index(): void {
    $this->guard();
    $tenant_id = (int)($_SESSION['tenant_id'] ?? 1);

    $license   = \LicenseService::current();
    $locations = \Location::allByTenant($tenant_id);

    require __DIR__ . '/../../views/settings/location/index.php';
  }

  public function store(): void {
    $this->guard();
    $tenant_id = (int)($_SESSION['tenant_id'] ?? 1);

    $name = trim($_POST['name'] ?? '');
    $code = trim($_POST['code'] ?? '');

    if ($name === '') {
      $_SESSION['flash_error'] = "Nama lokasi wajib diisi.";
      header("Location: " . url('/settings/locations'));
      exit;
    }

    try {
      \LicenseService::enforce_location_limit($tenant_id);
      \Location::create($tenant_id, $name, ($code === '' ? null : $code));
      $_SESSION['flash_success'] = "Lokasi berhasil ditambahkan.";
    } catch (\Exception $e) {
      $_SESSION['flash_error'] = $e->getMessage();
    }

    header("Location: " . url('/settings/locations'));
    exit;
  }

  public function toggle(): void {
    $this->guard();
    $tenant_id = (int)($_SESSION['tenant_id'] ?? 1);

    $id = (int)($_POST['id'] ?? 0);
    $active = (int)($_POST['is_active'] ?? 0);

    if ($id > 0) {
      \Location::setActive($tenant_id, $id, $active ? 1 : 0);
    }

    header("Location: " . url('/settings/locations'));
    exit;
  }
  
public function switch(): void {
  $this->guard();
  $tenant_id = (int)($_SESSION['tenant_id'] ?? 1);
  $location_id = (int)($_POST['location_id'] ?? 0);

  if ($location_id <= 0 || !\Location::belongsToTenant($tenant_id, $location_id)) {
    $_SESSION['flash_error'] = "Lokasi tidak valid.";
    header("Location: " . url('/settings/locations'));
    exit;
  }

  $_SESSION['location_id'] = $location_id;

  $back = trim((string)($_POST['back'] ?? ''));
  header("Location: " . ($back !== '' ? $back : url('/dashboard')));
  exit;
}


}
