<?php

function e(string $s): string {
  return htmlspecialchars($s, ENT_QUOTES, 'UTF-8');
}

function is_group_active(?string $activeMenu, array $keys): bool {
  $activeMenu = (string)($activeMenu ?? '');
  return in_array($activeMenu, $keys, true);
}

function normalize_asset(string $p): string {
  $p = trim((string)$p);
  if ($p === '') return '';
  if (preg_match('~^https?://~i', $p)) return $p;
  if (str_starts_with($p, '/')) return $p;
  return asset_url($p);
}

function svg_icon(string $name): string {
  $icons = [
    'dashboard' => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M3 13h8V3H3v10z"/><path d="M13 21h8V11h-8v10z"/><path d="M13 3h8v6h-8V3z"/><path d="M3 17h8v4H3v-4z"/></svg>',
    'customer'  => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/><circle cx="12" cy="7" r="4"/></svg>',
    'box'       => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M21 16V8a2 2 0 0 0-1-1.73L13 2.27a2 2 0 0 0-2 0L4 6.27A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"/><path d="M3.3 7l8.7 5 8.7-5"/><path d="M12 22V12"/></svg>',
    'cart'      => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><circle cx="9" cy="21" r="1"/><circle cx="20" cy="21" r="1"/><path d="M1 1h4l2.7 13.4a2 2 0 0 0 2 1.6h9.7a2 2 0 0 0 2-1.6L23 6H6"/></svg>',
    'percent'   => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M19 5 5 19"/><circle cx="6.5" cy="6.5" r="2.5"/><circle cx="17.5" cy="17.5" r="2.5"/></svg>',
    'users'     => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M17 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"/><circle cx="9" cy="7" r="4"/><path d="M23 21v-2a4 4 0 0 0-3-3.87"/><path d="M16 3.13a4 4 0 0 1 0 7.75"/></svg>',
    'wallet'    => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M21 12V7a2 2 0 0 0-2-2H5a2 2 0 0 0-2 2v10a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-5z"/><path d="M21 12h-6a2 2 0 0 0 0 4h6"/></svg>',
    'warehouse' => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M3 21V8l9-5 9 5v13"/><path d="M9 21v-9h6v9"/><path d="M3 11h18"/></svg>',
    'swap'      => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M17 1l4 4-4 4"/><path d="M21 5H9a4 4 0 0 0-4 4v2"/><path d="M7 23l-4-4 4-4"/><path d="M3 19h12a4 4 0 0 0 4-4v-2"/></svg>',
    'report'    => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M9 17v-6"/><path d="M12 17V7"/><path d="M15 17v-4"/><path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h10l6 6v10a2 2 0 0 1-2 2z"/><path d="M15 3v6h6"/></svg>',
    'puzzle'    => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><path d="M20 12a2 2 0 0 0-2-2h-1V8a2 2 0 0 0-2-2h-2V5a2 2 0 1 0-4 0v1H7a2 2 0 0 0-2 2v2H4a2 2 0 1 0 0 4h1v2a2 2 0 0 0 2 2h2v1a2 2 0 1 0 4 0v-1h2a2 2 0 0 0 2-2v-2h1a2 2 0 0 0 2-2z"/></svg>',
    'settings'  => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><circle cx="12" cy="12" r="3"/><path d="M19.4 15a7.8 7.8 0 0 0 .1-1 7.8 7.8 0 0 0-.1-1l2.1-1.6-2-3.4-2.5 1a7.5 7.5 0 0 0-1.7-1L13 2h-4l-.4 2.9a7.5 7.5 0 0 0-1.7 1l-2.5-1-2 3.4L4.5 13a7.8 7.8 0 0 0-.1 1 7.8 7.8 0 0 0 .1 1l-2.1 1.6 2 3.4 2.5-1a7.5 7.5 0 0 0 1.7 1L9 22h4l.4-2.9a7.5 7.5 0 0 0 1.7-1l2.5 1 2-3.4L19.4 15z"/></svg>',
    'default'   => '<svg class="mi" viewBox="0 0 24 24" aria-hidden="true"><circle cx="12" cy="12" r="9"/></svg>',
  ];
  return $icons[$name] ?? $icons['default'];
}

function menu_link(string $key, string $label, string $href, string $icon, bool $comingSoon=false): void {
  global $activeMenu;
  $activeMenu = (string)($activeMenu ?? '');
  $uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
$hrefPath = parse_url($href, PHP_URL_PATH) ?: $href;

$isActive = ($activeMenu === $key) || ($hrefPath !== '#' && $hrefPath !== '' && $hrefPath === $uri);


  $liClass = $isActive ? 'mm-active' : '';
  $data = $comingSoon ? ' data-coming-soon="1"' : '';
  $hrefAttr = $comingSoon ? '#' : $href;

  echo '<li class="'.$liClass.'">';
  echo '<a class="ai-icon'.($isActive ? ' is-active' : '').'" href="'.$hrefAttr.'" data-key="'.e($key).'"'.$data.'>';
  echo '<span class="menu-ic">'.svg_icon($icon).'</span>';
  echo '<span class="nav-text">'.e($label).'</span>';
  echo '</a></li>';
}

function menu_group_start(string $label, string $icon, array $childrenKeys): void {
  global $activeMenu;
  $activeMenu = (string)($activeMenu ?? '');
  $active = is_group_active($activeMenu, $childrenKeys);

  $liClass = $active ? 'mm-active is-open' : '';
  $aria = $active ? 'true' : 'false';

  echo '<li class="'.$liClass.'" data-has-sub="1">';
  echo '<a class="has-arrow ai-icon" href="#" aria-expanded="'.$aria.'">';
  echo '<span class="menu-ic">'.svg_icon($icon).'</span>';
  echo '<span class="nav-text">'.e($label).'</span>';
  echo '</a>';
  echo '<ul class="mm-collapse" aria-expanded="'.$aria.'">';
}

function menu_group_end(): void {
  echo '</ul></li>';
}

function menu_child(string $key, string $label, string $href='#', bool $comingSoon=true): void {
  global $activeMenu;
  $activeMenu = (string)($activeMenu ?? '');
  $isActive = ($activeMenu === $key);

  $data = $comingSoon ? ' data-coming-soon="1"' : '';
  $hrefAttr = $comingSoon ? '#' : $href;

  echo '<li class="'.($isActive ? 'mm-active' : '').'">';
  echo '<a href="'.$hrefAttr.'" data-key="'.e($key).'"'.$data.'>'.e($label).'</a>';
  echo '</li>';
}
