<?php

class Location {
  public static function allByTenant(int $tenant_id): array {
    $st = db()->prepare("SELECT * FROM locations WHERE tenant_id=? ORDER BY id DESC");
    $st->execute([$tenant_id]);
    return $st->fetchAll();
  }

  public static function countActiveByTenant(int $tenant_id): int {
    $st = db()->prepare("SELECT COUNT(*) c FROM locations WHERE tenant_id=?");
    $st->execute([$tenant_id]);
    return (int)($st->fetch()['c'] ?? 0);
  }

  public static function create(int $tenant_id, string $name, ?string $code): int {
    $st = db()->prepare("INSERT INTO locations (tenant_id, name, code, is_active, created_at) VALUES (?, ?, ?, 1, NOW())");
    $st->execute([$tenant_id, $name, $code]);
    return (int)db()->lastInsertId();
  }

  public static function setActive(int $tenant_id, int $id, int $active): void {
    $st = db()->prepare("UPDATE locations SET is_active=? , updated_at=NOW() WHERE tenant_id=? AND id=?");
    $st->execute([$active, $tenant_id, $id]);
  }
  
  public static function belongsToTenant(int $tenant_id, int $location_id): bool {
  $st = db()->prepare("SELECT 1 FROM locations WHERE tenant_id=? AND id=? LIMIT 1");
  $st->execute([$tenant_id, $location_id]);
  return (bool)$st->fetchColumn();
}

}
