<?php
declare(strict_types=1);

class LocationIdentity
{
  public static function getByLocation(int $tenant_id, int $location_id): ?array
  {
    $st = db()->prepare("SELECT * FROM location_identity WHERE tenant_id=? AND location_id=? LIMIT 1");
    $st->execute([$tenant_id, $location_id]);
    $row = $st->fetch();
    return $row ?: null;
  }

  public static function upsert(int $tenant_id, int $location_id, array $data): void
  {
    $exists = self::getByLocation($tenant_id, $location_id);

    $fields = ['logo_icon','logo_text','favicon','title','footer_text'];
    $vals = [];
    foreach ($fields as $f) {
      $vals[$f] = $data[$f] ?? null;
    }

    if (!$exists) {
      $st = db()->prepare("
        INSERT INTO location_identity
        (tenant_id, location_id, logo_icon, logo_text, favicon, title, footer_text, created_at, updated_at)
        VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW())
      ");
      $st->execute([
        $tenant_id, $location_id,
        $vals['logo_icon'], $vals['logo_text'], $vals['favicon'], $vals['title'], $vals['footer_text']
      ]);
      return;
    }

    $st = db()->prepare("
      UPDATE location_identity
      SET logo_icon=?, logo_text=?, favicon=?, title=?, footer_text=?, updated_at=NOW()
      WHERE tenant_id=? AND location_id=?
    ");
    $st->execute([
      $vals['logo_icon'], $vals['logo_text'], $vals['favicon'], $vals['title'], $vals['footer_text'],
      $tenant_id, $location_id
    ]);
  }
}
