<?php
declare(strict_types=1);

// Path request (tanpa query string)
$uri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
$basePath = parse_url(BASE_URL, PHP_URL_PATH) ?: '';
if ($basePath && str_starts_with($uri, $basePath)) {
  $uri = substr($uri, strlen($basePath));
}
$uri = '/' . ltrim($uri, '/');

// ------------------------------------------------------------
// AUTH GUARD (Sprint 2 Patch 2)
// - Semua halaman selain /login, /health, asset statis wajib login
// - Redirect ke /login jika belum ada session user_id
// ------------------------------------------------------------
$publicPaths = ['/login', '/health'];
if (!in_array($uri, $publicPaths, true)) {
  if (empty($_SESSION['user_id'])) {
    header('Location: ' . url('/login'));
    exit;
  }
}

switch (true) {

  // Health
  case $uri === '/health':
    header('Content-Type: application/json');
    echo json_encode(['ok' => true, 'time' => date('c')]);
    exit;


// Auth
case $uri === '/login':
  require_once APP_PATH . '/controllers/AuthController.php';
  $c = new \App\Controllers\AuthController();
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') === 'POST') $c->login();
  else $c->showLogin();
  exit;

case $uri === '/logout':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/AuthController.php';
  (new \App\Controllers\AuthController())->logout();
  exit;

// Gerbang / placeholder (Sprint 2)
case $uri === '/forgot-password':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'GET') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Auth/AuthController.php';
  (new \App\Controllers\Auth\AuthController())->forgotPassword();
  exit;

case $uri === '/signup':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'GET') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Auth/AuthController.php';
  (new \App\Controllers\Auth\AuthController())->signup();
  exit;



  // Dashboard (contoh halaman pakai layout global)
  case $uri === '/' || $uri === '/dashboard':
    require_once APP_PATH . '/controllers/DashboardController.php';
    (new \App\Controllers\DashboardController())->index();
    exit;

// Settings - Locations
case $uri === '/settings/locations':
  require_once APP_PATH . '/controllers/Settings/LocationController.php';
  (new \App\Controllers\Settings\LocationController())->index();
  exit;

case $uri === '/settings/locations/store':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/LocationController.php';
  (new \App\Controllers\Settings\LocationController())->store();
  exit;

case $uri === '/settings/locations/toggle':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/LocationController.php';
  (new \App\Controllers\Settings\LocationController())->toggle();
  exit;
  
  case $uri === '/settings/locations/switch':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/LocationController.php';
  (new \App\Controllers\Settings\LocationController())->switch();
  exit;


// Settings - Identity
case $uri === '/settings/identity':
  require_once APP_PATH . '/controllers/Settings/IdentityController.php';
  (new \App\Controllers\Settings\IdentityController())->edit();
  exit;

case $uri === '/settings/identity/update':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
 require_once APP_PATH . '/controllers/Settings/IdentityController.php';
  (new \App\Controllers\Settings\IdentityController())->update();
  exit;

// Settings - Users (Sprint 2)
case $uri === '/settings/users':
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->index();
  exit;

case $uri === '/settings/users/create':
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->create();
  exit;

case $uri === '/settings/users/store':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->store();
  exit;

case $uri === '/settings/users/edit':
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->edit();
  exit;

case $uri === '/settings/users/update':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->update();
  exit;

case $uri === '/settings/users/toggle':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') { http_response_code(405); exit; }
  require_once APP_PATH . '/controllers/Settings/UserController.php';
  (new \App\Controllers\Settings\UserController())->toggle();
  exit;

// ===============================
// Settings - Roles (Sprint 2)
// ===============================
case $uri === '/settings/roles':
  require_once APP_PATH . '/controllers/Settings/RoleController.php';
  (new App\Controllers\Settings\RoleController())->index();
  exit;

case $uri === '/settings/roles/create':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    http_response_code(405);
    exit;
  }
  require_once APP_PATH . '/controllers/Settings/RoleController.php';
  (new App\Controllers\Settings\RoleController())->store();
  exit;

case $uri === '/settings/roles/update':
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
    http_response_code(405);
    exit;
  }
  require_once APP_PATH . '/controllers/Settings/RoleController.php';
  (new App\Controllers\Settings\RoleController())->update();
  exit;




  http_response_code(404);
$_SESSION['flash_error'] = 'Halaman tidak ditemukan (404).';

$page_title = 'Not Found';
$breadcrumb_html = '404';

$view_file = APP_PATH . '/views/errors/empty.php';
require APP_PATH . '/views/layouts/app.php';
exit;

}
