<?php
declare(strict_types=1);

require_once APP_PATH . '/helpers/db.php';
require_once APP_PATH . '/models/LocationIdentity.php';

if (!class_exists('IdentityService', false)) {

  class IdentityService
  {
   public static function current(): array
{
  $tenant_id   = (int)($_SESSION['tenant_id'] ?? 1);
  $location_id = (int)($_SESSION['location_id'] ?? 1);

  $row = LocationIdentity::getByLocation($tenant_id, $location_id) ?: [];

  return [
    'logo_icon'   => $row['logo_icon'] ?? null,
    'logo_text'   => $row['logo_text'] ?? null,
    'favicon'     => $row['favicon'] ?? null,
    'title'       => $row['title'] ?? 'Printfreight',
    'footer_text' => $row['footer_text'] ?? '© Printfreight',
  ];
}

    public static function save(int $tenant_id, int $location_id, array $data): void
    {
      LocationIdentity::upsert($tenant_id, $location_id, $data);
    }
  }

}
