<?php
require_once APP_PATH . '/models/License.php';

class LicenseService {
  public static function current(): array {
    $tenant_id = (int)($_SESSION['tenant_id'] ?? 0);
    if ($tenant_id <= 0) return ['feature_flags'=>[], 'location_limit'=>1];

    $lic = License::getActiveByTenant($tenant_id);
    if (!$lic) return ['feature_flags'=>[], 'location_limit'=>1];

    $flags = [];
    if (!empty($lic['feature_flags'])) {
      $decoded = json_decode($lic['feature_flags'], true);
      if (is_array($decoded)) $flags = $decoded;
    }

    return [
      'plan_name' => $lic['plan_name'] ?? 'BASIC',
      'feature_flags' => $flags,
      'location_limit' => (int)($lic['location_limit'] ?? 1),
    ];
  }

  public static function feature(string $flag): bool {
    $lic = self::current();
    return !empty($lic['feature_flags'][$flag]);
  }

  public static function limit(string $key): int {
    $lic = self::current();
    if ($key === 'location_limit') return (int)$lic['location_limit'];
    return 0;
  }

  public static function enforce_location_limit(int $tenant_id): void {
    $limit = self::limit('location_limit');
    $count = Location::countActiveByTenant($tenant_id);
    if ($count >= $limit) {
      throw new Exception("Limit lokasi tercapai. Upgrade plan / add-on untuk menambah lokasi.");
    }
  }
}
