<?php
$pageTitle = 'Login';
$bodyClass = 'auth-page';

$logoSrc = asset_url('storage/uploads/logo-full.png');

// flash
$err = $_SESSION['flash_error'] ?? '';
unset($_SESSION['flash_error']);

$emailValue = htmlspecialchars((string)($_POST['email'] ?? ''), ENT_QUOTES);
?>

<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>
  <link rel="icon" href="<?= asset_url('img/favicon.png') ?>">
  <link rel="stylesheet" href="<?= asset_url('css/login.css') ?>">
</head>
<body class="<?= htmlspecialchars($bodyClass) ?>">

  <main class="auth">
    <section class="auth-card">
      <div class="auth-brand">
        <img class="auth-logo" src="<?= htmlspecialchars($logoSrc) ?>" alt="Printfreight">
      </div>

      <h1 class="auth-title">Sign in your account</h1>

      <?php if ($err !== ''): ?>
        <div class="auth-alert"><?= htmlspecialchars($err) ?></div>
      <?php endif; ?>

      <form class="auth-form" method="POST" action="<?= url('/login') ?>">
        <label class="auth-label" for="email">Email</label>
        <input class="auth-input" id="email" name="email" type="email" placeholder="hello@example.com" value="<?= $emailValue ?>" required>

        <label class="auth-label" for="password">Password</label>
        <div class="auth-password">
          <input class="auth-input" id="password" name="password" type="password" placeholder="••••••••" required>
          <button class="auth-eye" type="button" aria-label="Toggle password" data-eye>
            👁
          </button>
        </div>

        <div class="auth-row">
          <label class="auth-check">
            <input type="checkbox" name="remember" value="1">
            <span>Remember my preference</span>
          </label>

          <a class="auth-link" href="<?= url('/forgot-password') ?>">Forgot Password?</a>
        </div>

        <button class="auth-btn" type="submit">Sign Me In</button>

        <div class="auth-foot">
          Don't have an account?
          <a class="auth-link" href="<?= url('/signup') ?>">Sign up</a>
        </div>
      </form>
    </section>
  </main>

  <script>
    (function(){
      const btn = document.querySelector('[data-eye]');
      const inp = document.getElementById('password');
      if(!btn || !inp) return;
      btn.addEventListener('click', function(){
        inp.type = (inp.type === 'password') ? 'text' : 'password';
      });
    })();
  </script>
</body>
</html>
