<?php
/** @var string $pageTitle */
/** @var array $breadcrumb */
/** @var string $bodyClass */

$pageTitle  = $pageTitle ?? 'App';
$breadcrumb = $breadcrumb ?? [];
$bodyClass  = $bodyClass ?? 'app theme-light';

// Identity location (Sprint 1)
require_once APP_PATH . '/services/IdentityService.php';
$identity = IdentityService::current();

$identityTitle = trim((string)($identity['title'] ?? ''));
if ($identityTitle !== '') {
  if ($pageTitle === 'App' || $pageTitle === '') $pageTitle = $identityTitle;
}
$faviconPath = $identity['favicon'] ?? null;

// Switch location (Sprint 1)
require_once APP_PATH . '/models/Location.php';
$tenant_id = (int)($_SESSION['tenant_id'] ?? 1);
$current_location_id = (int)($_SESSION['location_id'] ?? 1);
$topbarLocations = Location::allByTenant($tenant_id);

// Sidebar brand helper (optional)
$brandName = $brandName ?? ($identityTitle !== '' ? $identityTitle : 'printfreight');

// Optional: hide big brand title (avoid double title on Settings pages)
$hideBrandHeader = $hideBrandHeader ?? false;

// Optional per-page css (additional)
$page_css = $page_css ?? [];
?>
<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= htmlspecialchars($pageTitle) ?></title>

  <?php if (!empty($faviconPath)): ?>
    <link rel="icon" href="<?= asset_url($faviconPath) ?>">
  <?php else: ?>
    <link rel="icon" href="<?= asset_url('img/favicon.png') ?>">
  <?php endif; ?>

  <link rel="stylesheet" href="<?= asset_url('css/global.css') ?>">
  <link rel="stylesheet" href="<?= asset_url('css/sidebar.css') ?>">
  <link rel="stylesheet" href="<?= asset_url('css/ui-theme.css') ?>">
<?php foreach ($page_css as $css): ?>
  <?php
    $full = PUBLIC_PATH . '/assets/' . ltrim($css, '/'); // sesuaikan jika struktur berbeda
    $v = is_file($full) ? filemtime($full) : time();
  ?>
  <link rel="stylesheet" href="<?= asset_url($css) ?>?v=<?= $v ?>">
<?php endforeach; ?>


<!-- DEBUG page_css: <?= htmlspecialchars(json_encode($page_css ?? null)) ?> -->

</head>

<body class="<?= htmlspecialchars($bodyClass) ?>">
<div class="app-shell">

  <?php require __DIR__ . '/sidebar.php'; ?>

  <div class="main" id="main">

    <header class="topbar">
  <div class="topbar__row">
    <!-- LEFT: sidebar buttons -->
    <div class="topbar__left">
      <button class="iconbtn" type="button" id="btnSidebarMobile" aria-label="Toggle sidebar">☰</button>
      <button class="iconbtn" type="button" id="btnSidebarExpand" aria-label="Expand sidebar">➜</button>
    </div>

    <!-- TITLE -->
    <div class="topbar__title">
      <h1 class="page-title"><?= htmlspecialchars($pageTitle) ?></h1>
    </div>

    <!-- RIGHT: switch location -->
    <div class="topbar__right">
      <?php
        $backUrl = $_SERVER['REQUEST_URI'] ?? '/dashboard';

        $currentLabel = 'Pilih Lokasi';
        foreach (($topbarLocations ?? []) as $l) {
          if ((int)$l['id'] === (int)$current_location_id) {
            $currentLabel = $l['name'] . (!empty($l['code']) ? ' (' . $l['code'] . ')' : '');
            break;
          }
        }
      ?>

      <div class="locswitch" data-locswitch>
        <button type="button" class="locswitch__btn" data-locswitch-btn>
          <span class="locswitch__label"><?= htmlspecialchars($currentLabel) ?></span>
        </button>

        <button type="button" class="locswitch__toggle" aria-label="Toggle lokasi" aria-expanded="false" data-locswitch-toggle>
          ▾
        </button>

        <div class="locswitch__menu" role="menu" aria-hidden="true" data-locswitch-menu>
          <?php foreach (($topbarLocations ?? []) as $l): ?>
            <form method="POST" action="<?= url('/settings/locations/switch'); ?>" class="locswitch__itemForm">
              <input type="hidden" name="back" value="<?= htmlspecialchars($backUrl) ?>">
              <input type="hidden" name="location_id" value="<?= (int)$l['id']; ?>">
              <button type="submit"
                      class="locswitch__item <?= ((int)$l['id'] === (int)$current_location_id) ? 'is-active' : ''; ?>"
                      role="menuitem">
                <?= htmlspecialchars($l['name']); ?><?= !empty($l['code']) ? ' (' . htmlspecialchars($l['code']) . ')' : ''; ?>
              </button>
            </form>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </div>

  <?php if (!empty($breadcrumb) && is_array($breadcrumb)): ?>
    <div class="topbar__crumb">
      <nav class="breadcrumb-pill" aria-label="breadcrumb">
        <?php foreach ($breadcrumb as $i => $bc): ?>
          <?php
            $label = $bc['label'] ?? '';
            $href  = $bc['href'] ?? null;
            $isLast = ($i === array_key_last($breadcrumb));
          ?>
          <?php if ($i > 0): ?><span class="breadcrumb-sep">/</span><?php endif; ?>

          <?php if (!$isLast && !empty($href)): ?>
            <a class="breadcrumb-link" href="<?= htmlspecialchars($href) ?>"><?= htmlspecialchars($label) ?></a>
          <?php else: ?>
            <span class="breadcrumb-current"><?= htmlspecialchars($label) ?></span>
          <?php endif; ?>
        <?php endforeach; ?>
      </nav>
    </div>
  <?php endif; ?>
</header>

   <div class="page">
  <?php if (empty($hideContentHeader)): ?>
    <div class="page__header">
      <div class="crumb">
        <?php foreach(($breadcrumb ?? []) as $i => $bc): ?>
          <?php
            $u = $bc['url'] ?? ($bc['href'] ?? null); // support dua format
          ?>
          <?php if (!empty($u)): ?>
            <a href="<?= htmlspecialchars($u) ?>"><?= htmlspecialchars($bc['label'] ?? '') ?></a>
          <?php else: ?>
            <span><?= htmlspecialchars($bc['label'] ?? '') ?></span>
          <?php endif; ?>
          <?php if ($i < count(($breadcrumb ?? [])) - 1): ?><span class="sep">›</span><?php endif; ?>
        <?php endforeach; ?>
      </div>

      <?php if (!$hideBrandHeader): ?>
        <div class="page__titleRow">
          <?php if (!empty($pageTitle)): ?>
            <h1 class="page-title"><?= htmlspecialchars($pageTitle) ?></h1>
          <?php else: ?>
            <h1 class="page-title"><?= htmlspecialchars($brandName) ?></h1>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>
  <?php endif; ?>

      <main class="page__inner">
