<?php
$activeMenu = (string)($activeMenu ?? '');

require_once __DIR__ . '/../../services/IdentityService.php';
require_once APP_PATH . '/helpers/auth_helper.php';
// kalau sudah di-require global via index.php, baris ini aman (tidak dobel)
require_once APP_PATH . '/helpers/sidebar_helpers.php';

$identity  = IdentityService::current();

$brandName = trim((string)($identity['title'] ?? 'printfreight'));
$logoIcon  = (string)($identity['logo_icon'] ?? '');
$logoText  = (string)($identity['logo_text'] ?? '');

$logoIconSrc = normalize_asset($logoIcon);
$logoTextSrc = normalize_asset($logoText);

$userName  = (string)($_SESSION['user_name'] ?? 'User');
$userEmail = (string)($_SESSION['user_email'] ?? '');
$userThumb = trim((string)($_SESSION['user_thumb'] ?? ''));
$thumbPath = ($userThumb !== '') ? $userThumb : 'storage/uploads/thumb.png';
?>

<aside class="sidebar sidebar--dompet" aria-label="Sidebar" id="appSidebar">
  <div class="dlabnav">
    <div class="dlabnav-scroll">

      <!-- HEADER (fixed) -->
      <div class="nav-header nav-header--inpanel">
        <div class="brand-logo">
          <div class="brand-icon">
            <?php if ($logoIconSrc !== ''): ?>
              <img src="<?= e($logoIconSrc) ?>" alt="<?= e($brandName) ?>">
            <?php else: ?>
              <img src="<?= asset_url('images/logo-icon.png') ?>" alt="<?= e($brandName) ?>">
            <?php endif; ?>
          </div>

          <div class="brand-text">
            <?php if ($logoTextSrc !== ''): ?>
              <img src="<?= e($logoTextSrc) ?>" alt="<?= e($brandName) ?>">
            <?php else: ?>
              <?= e($brandName) ?>
            <?php endif; ?>
          </div>
        </div>

        <!-- Desktop -->
        <button class="iconbtn iconbtn--ghost" id="btnSidebarCollapse" type="button" aria-label="Collapse sidebar">‹</button>

       
      </div>

      <!-- MENU (scroll only here) -->
      <div class="sidebar-menu-scroll" id="sidebarMenuScroll">
        <ul class="metismenu" id="menu">

          <!-- Profile dropdown -->
          <li class="dropdown header-profile">
            <button class="hp-trigger" type="button" data-hp-menu aria-expanded="false">
              <span class="hp-avatar">
                <img class="hp-avatar__img" src="<?= asset_url($thumbPath) ?>" alt="Avatar">
              </span>
              <span class="header-info">
                <span class="hp-hello">Hi, <b><?= e($userName) ?></b></span>
                <small class="hp-email"><?= e($userEmail) ?></small>
              </span>
              <span class="hp-caret">▾</span>
            </button>

            <div class="hp-menu" aria-hidden="true">
              <a href="#" class="hp-item" data-coming-soon="1">Profile</a>
              <div class="hp-divider"></div>
              <form class="hp-itemForm" action="<?= url('/logout') ?>" method="post">
                <button class="hp-item hp-item--btn" type="submit">Logout</button>
              </form>
            </div>
          </li>

          <?php
            // Existing
            menu_link('dashboard', 'Dashboard', url('/dashboard'), 'dashboard', false);

            // Dummy
            menu_link('customer', 'Customer', '#', 'customer', true);

            // Produk
            menu_group_start('Produk', 'box', ['produk.daftar','produk.kategori','produk.satuan']);
              menu_child('produk.daftar', 'Daftar Produk');
              menu_child('produk.kategori', 'Kategori Produk');
              menu_child('produk.satuan', 'Satuan');
            menu_group_end();

            // Penjualan
            menu_group_start('Penjualan', 'cart', ['jual.semua','jual.konsep','jual.penawaran','jual.pengiriman']);
              menu_child('jual.semua', 'Semua Penjualan');
              menu_child('jual.konsep', 'Daftar Konsep');
              menu_child('jual.penawaran', 'Daftar Penawaran');
              menu_child('jual.pengiriman', 'Pengiriman');
            menu_group_end();

            // Promo & Diskon
            menu_group_start('Promo & Diskon', 'percent', ['promo.campaign','promo.claim','promo.nego']);
              menu_child('promo.campaign', 'Campaign Promo');
              menu_child('promo.claim', 'Claim Potongan');
              menu_child('promo.nego', 'Nego Tracker WA');
            menu_group_end();

            // Agen
            menu_group_start('Agen', 'users', ['agen.list','agen.pos','agen.rekap']);
              menu_child('agen.list', 'Daftar Agen');
              menu_child('agen.pos', 'Pos Agen');
              menu_child('agen.rekap', 'Rekap Agen');
            menu_group_end();

            // Pengeluaran
            menu_group_start('Pengeluaran', 'wallet', ['out.biaya','out.bulletin']);
              menu_child('out.biaya', 'Daftar Biaya');
              menu_child('out.bulletin', 'Daftar Bulletin');
            menu_group_end();

            // Gudang
            menu_group_start('Gudang', 'warehouse', ['gudang.data','gudang.masuk','gudang.keluar']);
              menu_child('gudang.data', 'Data Barang');
              menu_child('gudang.masuk', 'Barang Masuk');
              menu_child('gudang.keluar', 'Barang Keluar');
            menu_group_end();

            // Peminjaman
            menu_group_start('Peminjaman', 'swap', ['pinjam.setting','pinjam.r2r','pinjam.r2raja']);
              menu_child('pinjam.setting', 'Setting');
              menu_child('pinjam.r2r', 'Rajawali -> Ranta');
              menu_child('pinjam.r2raja', 'Ranta -> Rajawali');
            menu_group_end();

            // Laporan
            menu_group_start('Laporan', 'report', ['lap.ringkasan','lap.masuk','lap.keluar','lap.gudang','lap.pinjam','lap.hutang','lap.order']);
              menu_child('lap.ringkasan', 'Ringkasan');
              menu_child('lap.masuk', 'Pemasukan');
              menu_child('lap.keluar', 'Pengeluaran');
              menu_child('lap.gudang', 'Laporan Gudang');
              menu_child('lap.pinjam', 'Laporan Peminjaman');
              menu_child('lap.hutang', 'Hutang Vendor');
              menu_child('lap.order', 'Order Tracker');
            menu_group_end();

            // Add On
            menu_group_start('Add On', 'puzzle', ['addon.offset','addon.nota','addon.gallery','addon.engine']);
              menu_child('addon.offset', 'Hitungan Offset');
              menu_child('addon.nota', 'Hitungan Nota');
              menu_child('addon.gallery', 'Gallery Assets');
              menu_child('addon.engine', 'Template Engine');
            menu_group_end();

            // Pengaturan
            menu_group_start('Pengaturan', 'settings', ['settings.lokasi','settings.identitas','settings.invoice','settings.roles']);
              if (has_permission('settings.locations.view')) {
                menu_child('settings.lokasi', 'Lokasi Bisnis', url('/settings/locations'), false);
              } else {
                menu_child('settings.lokasi', 'Lokasi Bisnis');
              }

              if (has_permission('settings.branding.view')) {
  menu_child('settings.identitas', 'Identitas Lokasi', url('/settings/identity'), false);
} else {
  menu_child('settings.identitas', 'Identitas Lokasi');
}


              menu_child('settings.invoice', 'Invoice'); // dummy

              if (has_permission('settings.roles.view')) {
                menu_child('settings.roles', 'Role & Permissions', url('/settings/roles'), false);
              } else {
                menu_child('settings.roles', 'Role & Permissions');
              }
            menu_group_end();

            // Users Management
            if (has_permission('settings.users.view')) {
              menu_link('users', 'User Management', url('/settings/users'), 'users', false);
            }
          ?>
        </ul>
      </div>

      <!-- FOOTER (fixed) -->
      <div class="copyright">
        <div><strong><?= e($brandName) ?></strong> © <?= date('Y') ?></div>
        <div class="fs-12">Core System</div>
      </div>

    </div>
  </div>
</aside>

<div class="backdrop" id="sidebarBackdrop" aria-hidden="true"></div>
