<?php
$pageTitle = 'Identitas Lokasi';
$breadcrumb = [
  ['label' => 'Settings', 'url' => url('/settings')],
  ['label' => 'Identitas Lokasi']
];
$hideContentHeader = true;   // penting biar header body lama tidak muncul
// data dari controller: $identity
$logoIcon = $identity['logo_icon'] ?? null;
$logoText = $identity['logo_text'] ?? null;
$favicon  = $identity['favicon'] ?? null;

function upload_preview(?string $path, string $alt, string $sizeClass = 'upload-preview__img--md'): string {
  if (empty($path)) {
    return '<div class="upload-preview__empty muted">Belum ada</div>';
  }

  // cache bust supaya setelah upload langsung berubah
  $src = asset_url($path) . '?v=' . time();

  return '
    <div class="upload-preview">
      <img
        class="upload-preview__img '.htmlspecialchars($sizeClass).'"
        src="'.htmlspecialchars($src).'"
        alt="'.htmlspecialchars($alt).'"
      >
      <div class="upload-preview__meta muted">
        <div class="upload-preview__label">Current:</div>
        <div class="upload-preview__path">'.htmlspecialchars($path).'</div>
      </div>
    </div>
  ';
}

require __DIR__ . '/../../layouts/header.php';
?>

<div class="card">
  <div class="card__title">Form Identitas</div>
  <div class="muted u-mb-10">
    Branding UI hanya identitas (logo/title/favicon/footer), tanpa ubah warna/tema.
  </div>

  <form method="POST" enctype="multipart/form-data" action="<?= url('/settings/identity/update'); ?>">
    <div class="grid grid-2">
      <div>
        <label>Title Browser</label>
        <input class="um-input" type="text" name="title" value="<?= htmlspecialchars($identity['title'] ?? '') ?>">
      </div>
      <div>
        <label>Footer Text</label>
        <input class="um-input" type="text" name="footer_text" value="<?= htmlspecialchars($identity['footer_text'] ?? '') ?>">
      </div>
    </div>

    <div class="grid grid-2 mt-16">
      <div>
        <label>Logo Icon (square)</label>
        <?= upload_preview($logoIcon, 'Logo Icon', 'upload-preview__img--lg'); ?>
        <input class="um-input" type="file" name="logo_icon" accept=".png,.jpg,.jpeg,.webp">
      </div>

      <div>
        <label>Logo Text (opsional)</label>
        <?= upload_preview($logoText, 'Logo Text', 'upload-preview__img--text'); ?>
        <input class="um-input" type="file" name="logo_text" accept=".png,.jpg,.jpeg,.webp">
      </div>
    </div>

    <div class="mt-16">
      <label>Favicon (.ico / .png)</label>
      <?= upload_preview($favicon, 'Favicon', 'upload-preview__img--sm'); ?>
      <input class="um-input" type="file" name="favicon" accept=".ico,.png">
    </div>

    <div class="mt-16">
       <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Simpan
</button>
    </div>
  </form>
</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
