<?php
$pageTitle = 'Lokasi Bisnis';
$breadcrumb = [
  ['label' => 'Settings', 'url' => url('/settings')],
  ['label' => 'Lokasi Bisnis'],
];
$hideContentHeader = true;   // penting biar header body lama tidak muncul
require __DIR__ . '/../../layouts/header.php';
?>

<?php if (!empty($_SESSION['flash_error'])): ?>
  <div class="card" style="border:1px solid rgba(255,0,0,.25);">
    <div class="muted" style="color:#b00020;">
      <?= htmlspecialchars($_SESSION['flash_error']); ?>
    </div>
  </div>
  <?php unset($_SESSION['flash_error']); ?>
<?php endif; ?>

<?php if (!empty($_SESSION['flash_success'])): ?>
  <div class="card" style="border:1px solid rgba(0,160,80,.25);">
    <div class="muted" style="color:#0a7a3c;">
      <?= htmlspecialchars($_SESSION['flash_success']); ?>
    </div>
  </div>
  <?php unset($_SESSION['flash_success']); ?>
<?php endif; ?>

<div class="grid grid-2 mt-16">

  <div class="card">
    <div class="card__title">Tambah Lokasi</div>
    <div class="muted" style="margin-bottom:10px">
      Limit lokasi: <?= (int)($license['location_limit'] ?? 1); ?>
    </div>

    <form method="POST" action="<?= url('/settings/locations/store'); ?>">
      <div class="grid grid-2">
        <div>
          <label>Nama</label>
          <input class="um-input" type="text" name="name" required />
        </div>
        <div>
          <label>Kode (opsional)</label>
         <input class="um-input" type="text" name="code" />
        </div>
      </div>

      <div class="mt-16">
        <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Simpan
</button>
      </div>
    </form>
  </div>

 <div class="card um-card">
  <div class="um-card-head">
    <div class="card__title">Daftar Lokasi</div>
  </div>

  <div class="um-tablewrap">
    <table class="table um-table" style="width:100%">
      <thead>
        <tr>
          <th style="text-align:left; width:70px;">ID</th>
          <th style="text-align:left">Nama</th>
          <th style="text-align:left; width:140px;">Kode</th>
          <th style="text-align:left; width:140px;">Status</th>
          <th class="um-th-actions" style="width:110px;">Aksi</th>
        </tr>
      </thead>

      <tbody>
        <?php foreach ($locations as $loc): ?>
          <?php $isActive = ((int)$loc['is_active'] === 1); ?>

          <tr>
            <td><?= (int)$loc['id']; ?></td>
            <td><?= htmlspecialchars($loc['name']); ?></td>
            <td><?= htmlspecialchars($loc['code'] ?? ''); ?></td>

            <td>
              <span class="um-badge <?= $isActive ? 'um-badge--success' : 'um-badge--danger'; ?>">
                <?= $isActive ? 'Aktif' : 'Nonaktif'; ?>
              </span>
            </td>

            <td class="um-actions">
              <form method="POST"
                    action="<?= url('/settings/locations/toggle'); ?>"
                    class="um-inline"
                    onsubmit="return confirm('Ubah status lokasi ini?');">
                <input type="hidden" name="id" value="<?= (int)$loc['id']; ?>" />
                <input type="hidden" name="is_active" value="<?= $isActive ? 0 : 1; ?>" />

                <button class="um-iconbtn <?= $isActive ? 'um-iconbtn--danger' : 'um-iconbtn--success'; ?>"
                        type="submit"
                        title="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>"
                        aria-label="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>">
                  ⏻
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if (empty($locations)): ?>
          <tr>
            <td colspan="5" class="muted">Belum ada lokasi.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>


</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
