<?php
$pageTitle = 'Roles & Permissions';
$breadcrumb = [
  ['label' => 'Settings', 'url' => url('/settings')],
  ['label' => 'Roles & Permissions', 'url' => null],
];

$hideContentHeader = true;   // penting biar header body lama tidak muncul

$page_css = ['css/role.css'];
require __DIR__ . '/../../layouts/header.php';
?>



  <?php if (!empty($_SESSION['flash_error'])): ?>
    <div class="alert alert--danger"><?= htmlspecialchars((string)$_SESSION['flash_error']) ?></div>
    <?php unset($_SESSION['flash_error']); ?>
  <?php endif; ?>

  <?php if (!empty($_SESSION['flash_success'])): ?>
    <div class="alert alert--success"><?= htmlspecialchars((string)$_SESSION['flash_success']) ?></div>
    <?php unset($_SESSION['flash_success']); ?>
  <?php endif; ?>
<div class="roles-page">
  <div class="roles-grid">
    <!-- LEFT -->
    <div class="card">
      <h3>Tambah Role</h3>

      <form method="POST" action="<?= url('/settings/roles/create') ?>">
        <label>Kode Role (unique)</label>
        <input class="um-input" name="code" placeholder="contoh: supervisor" required>
        <div class="hint">Huruf kecil / angka / underscore. 3–32 karakter.</div>

        <label>Nama Role</label>
         <input class="um-input" name="name" placeholder="Nama role" required>

        <label>Permissions (optional)</label>
        <div class="perm-scroll">
  <?php foreach ($permByModule as $module => $perms): ?>
    <div class="perm-group">
      <div class="perm-title"><?= htmlspecialchars($module) ?></div>

      <?php foreach ($perms as $p): ?>
        <?php $id = 'perm_' . preg_replace('/[^a-zA-Z0-9\-_]/', '_', $p['code']); ?>

        <div class="form-check custom-checkbox mb-2 checkbox-success">
          <input
            class="form-check-input"
            type="checkbox"
            id="<?= $id ?>"
            name="permissions[]"
            value="<?= htmlspecialchars($p['code']) ?>"
          >
          <label class="form-check-label" for="<?= $id ?>">
            <?= htmlspecialchars($p['name']) ?>
            <small>(<?= htmlspecialchars($p['code']) ?>)</small>
          </label>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endforeach; ?>
</div>


                        <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Simpan Role
</button>
      </form>
    </div>

    <!-- RIGHT -->
    <div class="card">
      <h3>Daftar Role</h3>

      <div class="accordion">
        <?php foreach ($roles as $r): ?>
          <?php
            $rid = (int)$r['id'];
            $rcode = (string)$r['code'];
            $rname = (string)$r['name'];
            $checkedMap = $rolePerm[$rid] ?? [];
          ?>

          <details class="acc-item">
            <summary class="acc-head">
              <div class="acc-title">
                <b><?= htmlspecialchars($rname) ?></b>
                <span class="badge badge--pill"><?= htmlspecialchars($rcode) ?></span>

              </div>
              <div class="acc-action">Edit permissions</div>
            </summary>

            <div class="acc-body">
              <form method="POST" action="<?= url('/settings/roles/update') ?>">
                <input type="hidden" name="role_id" value="<?= $rid ?>">

                <label>Nama Role</label>
                 <input class="um-input" name="name" value="<?= htmlspecialchars($rname) ?>" required>

                <div class="perm-grid">
                  <?php foreach ($permByModule as $module => $perms): ?>
                    <div class="perm-box">
                      <div class="perm-title"><?= htmlspecialchars($module) ?></div>

                      <?php foreach ($perms as $p): ?>
                        <?php $code = (string)$p['code']; ?>
                        <label class="perm-item">
                          <input
                            type="checkbox"
                            name="permissions[]"
                            value="<?= htmlspecialchars($code) ?>"
                            <?= isset($checkedMap[$code]) ? 'checked' : '' ?>
                          >
                          <span>
                            <?= htmlspecialchars($p['name']) ?>
                            <small>(<?= htmlspecialchars($code) ?>)</small>
                          </span>
                        </label>
                      <?php endforeach; ?>
                    </div>
                  <?php endforeach; ?>
                </div>

                <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Simpan
</button>
              </form>
            </div>
          </details>

        <?php endforeach; ?>
      </div>
    </div>
  </div>
</div>


<?php require __DIR__ . '/../../layouts/footer.php'; ?>