<?php
$pageTitle = 'Tambah User';
$breadcrumb = [
  ['label' => 'Settings', 'url' => url('/settings')],
  ['label' => 'Users', 'url' => url('/settings/users')],
  ['label' => 'Tambah User'],
];

$page_css = ['css/user.css'];
require __DIR__ . '/../../layouts/header.php';
?>

<?php if (!empty($_SESSION['flash_error'])): ?>
  <div class="um-alert um-alert--error" role="alert">
    <?= htmlspecialchars($_SESSION['flash_error']); ?>
  </div>
  <?php unset($_SESSION['flash_error']); ?>
<?php endif; ?>

<div class="card um-card">
  <div class="um-card__head">
    <div class="um-card__title">Form User</div>

    <div class="um-head-actions">
<a class="ui-btn ui-btn--gray" href="<?= url('/settings/users'); ?>">
  <span class="ui-btn__icon" aria-hidden="true">
    <!-- back arrow (mirip contoh), pakai FILL -->
    <svg viewBox="0 0 24 24" aria-hidden="true" focusable="false">
      <path fill="currentColor" d="M14.7 6.3a1 1 0 0 1 0 1.4L10.41 12l4.29 4.3a1 1 0 1 1-1.4 1.4l-5-5a1 1 0 0 1 0-1.4l5-5a1 1 0 0 1 1.4 0z"/>
    </svg>
  </span>
  Kembali
</a>

    </div>
  </div>

  <form class="um-form"
        method="POST"
        action="<?= url('/settings/users/store'); ?>"
        enctype="multipart/form-data">

    <!-- Informasi Dasar -->
    <div class="um-section">
      <div class="um-section__title">Informasi Dasar</div>

      <div class="um-grid-2">
        <div class="um-field">
          <label class="um-label">Nama</label>
          <input class="um-input" type="text" name="name" required />
        </div>

        <div class="um-field">
          <label class="um-label">Email</label>
          <input class="um-input" type="email" name="email" required />
        </div>

        <div class="um-field">
          <label class="um-label">Jabatan <span class="um-muted">(opsional)</span></label>
          <input class="um-input" type="text" name="job_title" placeholder="admin / kepala toko / kasir / karyawan" />
        </div>

        <div class="um-field">
          <label class="um-label">Thumbnail <span class="um-muted">(opsional)</span></label>
          <input class="um-input" type="file" name="thumbnail" accept=".png,.jpg,.jpeg,.webp" />
          <div class="um-help">Upload ke: <span class="um-mono">storage/uploads/users/</span></div>
        </div>
      </div>
    </div>

    <!-- Akun -->
    <div class="um-section">
      <div class="um-section__title">Akun</div>

      <div class="um-grid-2">
        <div class="um-field">
          <label class="um-label">Password</label>
          <input class="um-input" type="password" name="password" required />
        </div>

        <div class="um-field">
          <label class="um-label">Konfirmasi Password</label>
          <input class="um-input" type="password" name="password_confirm" required />
        </div>
      </div>
    </div>

    <!-- Role -->
    <div class="um-section">
      <div class="um-section__title">Role (multi)</div>
      <div class="um-help">Minimal pilih 1 role.</div>

      <div class="um-checkgrid">
        <?php foreach (($roles ?? []) as $r): ?>
          <label class="um-check">
            <input class="um-check__box" type="checkbox" name="roles[]" value="<?= (int)$r['id']; ?>" />
            <span class="um-check__label"><?= htmlspecialchars((string)($r['name'] ?? '')); ?></span>
          </label>
        <?php endforeach; ?>

        <?php if (empty($roles)): ?>
          <div class="um-muted">Role belum tersedia.</div>
        <?php endif; ?>
      </div>
    </div>

    <!-- Lokasi -->
    <div class="um-section">
      <div class="um-section__title">Akses Lokasi</div>
      <div class="um-help">Minimal pilih 1 lokasi.</div>

      <div class="um-checkgrid">
        <?php foreach (($locations ?? []) as $l): ?>
          <label class="um-check">
            <input class="um-check__box" type="checkbox" name="locations[]" value="<?= (int)$l['id']; ?>" />
            <span class="um-check__label">
              <?= htmlspecialchars((string)($l['name'] ?? '')); ?>
              <?= !empty($l['code']) ? ' (' . htmlspecialchars((string)$l['code']) . ')' : ''; ?>
            </span>
          </label>
        <?php endforeach; ?>

        <?php if (empty($locations)): ?>
          <div class="um-muted">Lokasi belum tersedia.</div>
        <?php endif; ?>
      </div>

      <div class="um-help" style="margin-top:8px">
        Jika user hanya punya 1 lokasi, sistem akan auto-set lokasi aktif saat login.
      </div>
    </div>

    <div class="um-form__actions">
      <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Simpan
</button>

    </div>
  </form>
</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
