<?php
$pageTitle = 'Edit User';
$breadcrumb = [
  ['label' => 'Settings', 'url' => url('/settings')],
  ['label' => 'Users', 'url' => url('/settings/users')],
  ['label' => 'Edit User'],
];

$page_css = ['css/user.css'];
require __DIR__ . '/../../layouts/header.php';

$uid = (int)($user['id'] ?? 0);
$isActive = ((int)($user['is_active'] ?? 1) === 1);

$currentThumb = trim((string)($user['thumbnail'] ?? ''));
if ($currentThumb !== '' && str_starts_with($currentThumb, 'storage/')) {
  $currentThumb = substr($currentThumb, 8);
}
$thumbSrc = $currentThumb !== ''
  ? asset_url('storage/' . $currentThumb)
  : asset_url('storage/uploads/thumb.png');
?>

<?php if (!empty($_SESSION['flash_error'])): ?>
  <div class="um-alert um-alert--error" role="alert">
    <?= htmlspecialchars($_SESSION['flash_error']); ?>
  </div>
  <?php unset($_SESSION['flash_error']); ?>
<?php endif; ?>

<?php if (!empty($_SESSION['flash_success'])): ?>
  <div class="um-alert um-alert--success" role="alert">
    <?= htmlspecialchars($_SESSION['flash_success']); ?>
  </div>
  <?php unset($_SESSION['flash_success']); ?>
<?php endif; ?>

<div class="card um-card">
  <div class="um-card__head">
    <div class="um-card__title">Form Edit</div>

    <div class="um-head-actions">
<a class="ui-btn ui-btn--gray" href="<?= url('/settings/users'); ?>">
  <span class="ui-btn__icon" aria-hidden="true">
    <!-- back arrow (mirip contoh), pakai FILL -->
    <svg viewBox="0 0 24 24" aria-hidden="true" focusable="false">
      <path fill="currentColor" d="M14.7 6.3a1 1 0 0 1 0 1.4L10.41 12l4.29 4.3a1 1 0 1 1-1.4 1.4l-5-5a1 1 0 0 1 0-1.4l5-5a1 1 0 0 1 1.4 0z"/>
    </svg>
  </span>
  Kembali
</a>



      <form method="POST" action="<?= url('/settings/users/toggle'); ?>" class="um-inline">
        <input type="hidden" name="id" value="<?= $uid; ?>" />
        <input type="hidden" name="is_active" value="<?= $isActive ? 0 : 1; ?>" />
        <button class="um-iconbtn <?= $isActive ? 'um-iconbtn--danger' : 'um-iconbtn--success'; ?>"
                type="submit"
                title="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>"
                aria-label="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>">
          ⏻
        </button>
      </form>

      <?php if ($isActive): ?>
        <span class="um-badge um-badge--success">Aktif</span>
      <?php else: ?>
        <span class="um-badge um-badge--danger">Nonaktif</span>
      <?php endif; ?>
    </div>
  </div>

  <form class="um-form"
        method="POST"
        action="<?= url('/settings/users/update'); ?>"
        enctype="multipart/form-data">
    <input type="hidden" name="id" value="<?= $uid; ?>" />

    <!-- Informasi Dasar -->
    <div class="um-section">
      <div class="um-section__title">Informasi Dasar</div>

      <div class="um-grid-2">
        <div class="um-field">
          <label class="um-label">Nama</label>
          <input class="um-input" type="text" name="name" required value="<?= htmlspecialchars((string)($user['name'] ?? '')); ?>" />
        </div>

        <div class="um-field">
          <label class="um-label">Email</label>
          <input class="um-input" type="email" name="email" required value="<?= htmlspecialchars((string)($user['email'] ?? '')); ?>" />
        </div>

        <div class="um-field">
          <label class="um-label">Jabatan <span class="um-muted">(opsional)</span></label>
          <input class="um-input"
                 type="text"
                 name="job_title"
                 value="<?= htmlspecialchars((string)($user['job_title'] ?? '')); ?>"
                 placeholder="Admin / Kepala Toko / Kasir" />
        </div>

        <div class="um-field">
          <label class="um-label">Ganti Thumbnail <span class="um-muted">(opsional)</span></label>
          <input class="um-input" type="file" name="thumbnail" accept=".png,.jpg,.jpeg,.webp" />
          <div class="um-help">Upload ke: <span class="um-mono">storage/uploads/users/</span></div>

          <div class="um-avatar">
            <img class="um-avatar__img" src="<?= $thumbSrc ?>" alt="Current Thumbnail">
            <div class="um-avatar__meta">
              <div class="um-muted">Current:</div>
              <div class="um-mono"><?= htmlspecialchars((string)($user['thumbnail'] ?: 'default')); ?></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- Password -->
    <div class="um-section">
      <div class="um-section__title">Password</div>
      <div class="um-help">Kosongkan jika tidak diganti.</div>

      <div class="um-grid-2">
        <div class="um-field">
          <label class="um-label">Password Baru <span class="um-muted">(opsional)</span></label>
          <input class="um-input" type="password" name="password" placeholder="Kosongkan jika tidak diganti" />
        </div>

        <div class="um-field">
          <label class="um-label">Konfirmasi Password Baru</label>
          <input class="um-input" type="password" name="password_confirm" placeholder="Kosongkan jika tidak diganti" />
        </div>
      </div>
    </div>

    <!-- Role -->
    <div class="um-section">
      <div class="um-section__title">Role (multi)</div>
      <div class="um-help">Minimal pilih 1 role.</div>

      <div class="um-checkgrid">
        <?php foreach (($roles ?? []) as $r): ?>
          <?php $rid = (int)($r['id'] ?? 0); $checked = in_array($rid, (array)($userRoleIds ?? []), true); ?>
          <label class="um-check">
            <input class="um-check__box" type="checkbox" name="roles[]" value="<?= $rid; ?>" <?= $checked ? 'checked' : ''; ?> />
            <span class="um-check__label"><?= htmlspecialchars((string)($r['name'] ?? '')); ?></span>
          </label>
        <?php endforeach; ?>
      </div>
    </div>

    <!-- Lokasi -->
    <div class="um-section">
      <div class="um-section__title">Akses Lokasi</div>
      <div class="um-help">Minimal pilih 1 lokasi.</div>

      <div class="um-checkgrid">
        <?php foreach (($locations ?? []) as $l): ?>
          <?php $lid = (int)($l['id'] ?? 0); $checked = in_array($lid, (array)($userLocationIds ?? []), true); ?>
          <label class="um-check">
            <input class="um-check__box" type="checkbox" name="locations[]" value="<?= $lid; ?>" <?= $checked ? 'checked' : ''; ?> />
            <span class="um-check__label">
              <?= htmlspecialchars((string)($l['name'] ?? '')); ?>
              <?= !empty($l['code']) ? ' (' . htmlspecialchars((string)$l['code']) . ')' : ''; ?>
            </span>
          </label>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="um-form__actions">
      <button class="ui-btn ui-btn--green" type="submit">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M20 7L10 17l-5-5" stroke="currentColor" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/>
    </svg>
  </span>
  Update
</button>

    </div>
  </form>
</div>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
