<?php
$pageTitle = "User Management";
$breadcrumb = [
  ["label" => "Settings", "href" => url('/settings')],
  ["label" => "User Management", "href" => null],
];

$hideContentHeader = true;   // <— tambahin ini
$page_css = ['css/user.css'];
require __DIR__ . '/../../layouts/header.php';
?>

<?php if (!empty($_SESSION['flash_error'])): ?>
  <div class="um-alert um-alert--error" role="alert">
    <?= htmlspecialchars($_SESSION['flash_error']); ?>
  </div>
  <?php unset($_SESSION['flash_error']); ?>
<?php endif; ?>

<?php if (!empty($_SESSION['flash_success'])): ?>
  <div class="um-alert um-alert--success" role="alert">
    <?= htmlspecialchars($_SESSION['flash_success']); ?>
  </div>
  <?php unset($_SESSION['flash_success']); ?>
<?php endif; ?>

<div class="card um-card">
  <div class="um-card__head">
    <div class="um-card__title">Daftar User</div>

    <div class="um-head-actions">
      <input type="text"
             class="um-search__input"
             placeholder="Cari nama / email / role..."
             autocomplete="off"
             data-um-search>

      <a class="ui-btn ui-btn--teal" href="<?= url('/settings/users/create'); ?>">
  <span class="ui-btn__icon" aria-hidden="true">
    <svg viewBox="0 0 24 24" fill="none">
      <path d="M12 5v14M5 12h14" stroke="currentColor" stroke-width="2.5" stroke-linecap="round"/>
    </svg>
  </span>
  Tambah User
</a>

    </div>
  </div>

  <div class="um-tablewrap">
    <table class="table um-table" data-um-table>
      <thead>
        <tr>
          <th>Nama</th>
          <th>Email</th>
          <th>Role</th>
          <th>Akses Lokasi</th>
          <th>Status</th>
          <th class="um-th-actions">Aksi</th>
        </tr>
      </thead>

      <tbody>
        <?php foreach (($users ?? []) as $u): ?>
          <?php
            $name      = (string)($u['name'] ?? '');
            $email     = (string)($u['email'] ?? '');
            $rolesText = trim((string)($u['roles_text'] ?? ''));
            $locCount  = (int)($u['locations_count'] ?? 0);
            $locText   = $locCount <= 0 ? '-' : ($locCount === 1 ? '1 lokasi' : ($locCount . ' lokasi'));
            $isActive  = ((int)($u['is_active'] ?? 1) === 1);
            $userId    = (int)($u['id'] ?? 0);

            // search token (lebih cepat daripada innerText)
            $search = strtolower(trim($name . ' ' . $email . ' ' . $rolesText));
          ?>

          <tr data-um-row data-search="<?= htmlspecialchars($search); ?>">
            <td class="um-td-name"><?= htmlspecialchars($name); ?></td>
            <td class="um-td-email"><?= htmlspecialchars($email); ?></td>

            <td>
              <?php if ($rolesText !== ''): ?>
                <?= htmlspecialchars($rolesText); ?>
              <?php else: ?>
                <span class="muted">-</span>
              <?php endif; ?>
            </td>

            <td><?= htmlspecialchars($locText); ?></td>

            <td>
              <?php if ($isActive): ?>
                <span class="um-badge um-badge--success">Aktif</span>
              <?php else: ?>
                <span class="um-badge um-badge--danger">Nonaktif</span>
              <?php endif; ?>
            </td>

            <td class="um-actions">
              <a class="um-iconbtn um-iconbtn--edit"
                 href="<?= url('/settings/users/edit?id=' . $userId); ?>"
                 title="Edit"
                 aria-label="Edit">
                ✎
              </a>

              <form method="POST"
                    action="<?= url('/settings/users/toggle'); ?>"
                    class="um-inline">
                <input type="hidden" name="id" value="<?= $userId; ?>" />
                <input type="hidden" name="is_active" value="<?= $isActive ? 0 : 1; ?>" />

                <button class="um-iconbtn <?= $isActive ? 'um-iconbtn--danger' : 'um-iconbtn--success'; ?>"
                        type="submit"
                        title="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>"
                        aria-label="<?= $isActive ? 'Nonaktifkan' : 'Aktifkan'; ?>">
                  ⏻
                </button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>

        <?php if (empty($users)): ?>
          <tr>
            <td colspan="6" class="muted um-empty">Belum ada user.</td>
          </tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
(function(){
  const input = document.querySelector('[data-um-search]');
  const table = document.querySelector('[data-um-table]');
  if(!input || !table) return;

  const rows = Array.from(table.querySelectorAll('tbody tr[data-um-row]'));

  function norm(s){
    return (s || '').toString().toLowerCase().trim();
  }

  input.addEventListener('input', () => {
    const q = norm(input.value);
    rows.forEach(tr => {
      const hay = norm(tr.getAttribute('data-search'));
      tr.style.display = (q === '' || hay.includes(q)) ? '' : 'none';
    });
  });
})();
</script>

<?php require __DIR__ . '/../../layouts/footer.php'; ?>
