-- ============================================================
-- 002_auth_patch2_seed.sql — Seed tambahan untuk Sprint 2 Patch 2
-- Jalankan SETELAH migrations/002_auth.sql
-- ============================================================

-- 1) Owner user default (DEV)
-- Login:
--   email: owner@rajawali.local
--   pass : 1234
INSERT IGNORE INTO users (id, tenant_id, name, email, password_hash, is_active, is_owner, created_at)
VALUES
  (1, 1, 'Owner', 'owner@rajawali.local', '$2y$10$FhRL.9QDb22QFqTFEN9v5.A7PRZJ4lRsl6wTDyD3EVpOVYtp/xnfa', 1, 1, NOW());

-- 2) Assign role owner ke user id 1 (optional, karena owner bypass)
INSERT IGNORE INTO user_roles (user_id, role_id)
SELECT 1, r.id FROM roles r WHERE r.tenant_id=1 AND r.code='owner' LIMIT 1;

-- 3) Akses lokasi default (min 1 lokasi)
-- Asumsi locations id=1 sudah ada (Sprint 1)
INSERT IGNORE INTO user_locations (user_id, location_id) VALUES (1, 1);

-- 4) Role permission minimal biar bisa langsung dites
-- Helper: map permission by code
-- Admin: semua permission
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id
FROM roles r
JOIN permissions p
WHERE r.tenant_id=1 AND r.code='admin';

-- Kasir: POS view saja
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id
FROM roles r
JOIN permissions p ON p.code IN ('pos.view')
WHERE r.tenant_id=1 AND r.code='kasir';

-- Kepala Toko: POS view, produk & customer view/edit, report view
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id
FROM roles r
JOIN permissions p ON p.code IN ('pos.view','products.view','products.edit','customers.view','customers.edit','reports.view')
WHERE r.tenant_id=1 AND r.code='kepala_toko';

-- Karyawan: produk & customer view
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id
FROM roles r
JOIN permissions p ON p.code IN ('products.view','customers.view')
WHERE r.tenant_id=1 AND r.code='karyawan';

-- Owner: tidak perlu mapping (bypass di app), tapi boleh disamakan full
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT r.id, p.id
FROM roles r
JOIN permissions p
WHERE r.tenant_id=1 AND r.code='owner';
