/* =========================================================
   RAJAWALI CORE SYSTEM - Sprint 2 (A)
   Seed Permissions + Role Permission Mapping
   Goal: Kasir hanya POS (pos.view), Settings terblok
   ========================================================= */

START TRANSACTION;

/* ---------- 1) PERMISSIONS CATALOG (SYSTEM) ---------- */
/* Assumption table: permissions(code, name, group_key, is_system) */

INSERT INTO permissions (code, name, group_key, is_system) VALUES
-- DASHBOARD
('dashboard.view', 'Lihat Dashboard', 'DASHBOARD', 1),

-- POS
('pos.view', 'Lihat POS', 'POS', 1),

-- SETTINGS - BRANDING
('settings.branding.view', 'Lihat Branding', 'SETTINGS', 1),
('settings.branding.edit', 'Edit Branding', 'SETTINGS', 1),

-- SETTINGS - LOCATIONS
('settings.locations.view', 'Lihat Lokasi Bisnis', 'SETTINGS', 1),
('settings.locations.add', 'Tambah Lokasi Bisnis', 'SETTINGS', 1),
('settings.locations.edit', 'Edit/Toggle Lokasi Bisnis', 'SETTINGS', 1),

-- SETTINGS - ROLES
('settings.roles.view', 'Lihat Roles & Permissions', 'SETTINGS', 1),
('settings.roles.add', 'Tambah Role', 'SETTINGS', 1),
('settings.roles.edit', 'Edit Role Permissions', 'SETTINGS', 1),

-- SETTINGS - USERS
('settings.users.view', 'Lihat Users', 'SETTINGS', 1),
('settings.users.add', 'Tambah Users', 'SETTINGS', 1),
('settings.users.edit', 'Edit Users', 'SETTINGS', 1),
('settings.users.toggle', 'Aktif/Nonaktif Users', 'SETTINGS', 1)
ON DUPLICATE KEY UPDATE
  name=VALUES(name),
  group_key=VALUES(group_key),
  is_system=VALUES(is_system);


/* ---------- 2) ROLE -> PERMISSION MAPPING ---------- */
/* Assumption tables:
   roles(code, ...)
   role_permissions(role_id, permission_id)
*/

-- Helper: set role_id vars by code
SET @role_owner       := (SELECT id FROM roles WHERE code='owner' LIMIT 1);
SET @role_admin       := (SELECT id FROM roles WHERE code='admin' LIMIT 1);
SET @role_kepala_toko := (SELECT id FROM roles WHERE code='kepala_toko' LIMIT 1);
SET @role_kasir       := (SELECT id FROM roles WHERE code='kasir' LIMIT 1);
SET @role_karyawan    := (SELECT id FROM roles WHERE code='karyawan' LIMIT 1);

-- OWNER: (opsional) mapping full catalog. Owner tetap bypass di helper, tapi ini bikin UI checklist kelihatan full.
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT @role_owner, p.id
FROM permissions p
WHERE p.is_system = 1;

-- ADMIN: full (Sprint 2 core)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT @role_admin, p.id
FROM permissions p
WHERE p.is_system = 1;

-- KEPALA TOKO: dashboard + pos + view settings tertentu (tanpa role edit jika kamu mau lebih ketat)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT @role_kepala_toko, p.id
FROM permissions p
WHERE p.code IN (
  'dashboard.view',
  'pos.view',
  'settings.locations.view',
  'settings.locations.add',
  'settings.locations.edit',
  'settings.users.view',
  'settings.users.add',
  'settings.users.edit',
  'settings.users.toggle'
);

-- KASIR: hanya POS (opsional dashboard)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT @role_kasir, p.id
FROM permissions p
WHERE p.code IN (
  'pos.view'
  -- 'dashboard.view'  -- aktifkan kalau kasir boleh lihat dashboard
);

-- KARYAWAN: minimal dashboard (opsional)
INSERT IGNORE INTO role_permissions (role_id, permission_id)
SELECT @role_karyawan, p.id
FROM permissions p
WHERE p.code IN (
  'dashboard.view'
);

COMMIT;
