// Location switch dropdown
(function () {
  const root = document.querySelector('[data-locswitch]');
  if (!root) return;

  const btn = root.querySelector('[data-locswitch-btn]');
  const toggle = root.querySelector('[data-locswitch-toggle]');
  const menu = root.querySelector('[data-locswitch-menu]');

  function open() {
    root.classList.add('is-open');
    toggle?.setAttribute('aria-expanded', 'true');
    menu?.setAttribute('aria-hidden', 'false');
  }

  function close() {
    root.classList.remove('is-open');
    toggle?.setAttribute('aria-expanded', 'false');
    menu?.setAttribute('aria-hidden', 'true');
  }

  function isOpen() {
    return root.classList.contains('is-open');
  }

  btn?.addEventListener('click', () => (isOpen() ? close() : open()));
  toggle?.addEventListener('click', () => (isOpen() ? close() : open()));

  document.addEventListener('click', (e) => {
    if (!root.contains(e.target)) close();
  });

  document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') close();
  });
})();
