// public/assets/js/sidebar.js
(function () {
  const body = document.body;
  const sidebar = document.getElementById('appSidebar');
  const backdrop = document.getElementById('sidebarBackdrop');

  // NOTE: pastikan ID ini hanya ADA 1x (di TOPBAR, bukan di sidebar.php)
  const btnMobile = document.querySelector('#btnSidebarMobile');
  const btnCollapse = document.getElementById('btnSidebarCollapse');
  const btnExpand = document.getElementById('btnSidebarExpand');

  const KEY = 'pf_sidebar_collapsed';

  function openMobile() {
    body.classList.add('sidebar-open');
    backdrop?.setAttribute('aria-hidden', 'false');
  }
  function closeMobile() {
    body.classList.remove('sidebar-open');
    backdrop?.setAttribute('aria-hidden', 'true');
  }

  function isDesktop() {
    return window.innerWidth >= 992;
  }

  // Load persisted collapse (DESKTOP ONLY)
  if (isDesktop() && localStorage.getItem(KEY) === '1') {
    body.classList.add('sidebar-collapsed');
  } else {
    // Mobile: jangan pernah collapsed
    body.classList.remove('sidebar-collapsed');
  }

  // Mobile toggle
  btnMobile?.addEventListener(
    'click',
    (e) => {
      e.preventDefault();
      e.stopPropagation();
      body.classList.contains('sidebar-open') ? closeMobile() : openMobile();
    },
    true
  );

  backdrop?.addEventListener(
    'click',
    (e) => {
      e.preventDefault();
      e.stopPropagation();
      closeMobile();
    },
    true
  );

  // Desktop collapse
  btnCollapse?.addEventListener(
    'click',
    (e) => {
      e.preventDefault();
      e.stopPropagation();

      // Collapse only on desktop
      if (!isDesktop()) return;

      body.classList.add('sidebar-collapsed');
      body.classList.add('pf-anim-collapse');
      setTimeout(() => body.classList.remove('pf-anim-collapse'), 400);

      localStorage.setItem(KEY, '1');

      document
        .querySelectorAll('.sidebar--dompet li.popup-open')
        .forEach((li) => li.classList.remove('popup-open'));
    },
    true
  );

  // Desktop expand
  btnExpand?.addEventListener(
    'click',
    (e) => {
      e.preventDefault();
      e.stopPropagation();

      // Expand only on desktop
      if (!isDesktop()) return;

      body.classList.remove('sidebar-collapsed');
      body.classList.add('pf-anim-expand');
      setTimeout(() => body.classList.remove('pf-anim-expand'), 350);

      localStorage.setItem(KEY, '0');

      document
        .querySelectorAll('.sidebar--dompet li.popup-open')
        .forEach((li) => li.classList.remove('popup-open'));
    },
    true
  );

  function isCollapsedDesktop() {
    return body.classList.contains('sidebar-collapsed') && isDesktop();
  }

  function setPopupPos(li) {
    if (!sidebar) return;

    const ul = li.querySelector(':scope > ul.mm-collapse');
    if (!ul) return;

    const liRect = li.getBoundingClientRect();
    const sbRect = sidebar.getBoundingClientRect();

    const left = Math.round(sbRect.right + 10);
    const top = Math.round(
      Math.max(10, Math.min(liRect.top, window.innerHeight - 260))
    );

    body.style.setProperty('--sb-popup-left', left + 'px');
    body.style.setProperty('--sb-popup-top', top + 'px');
  }

  // Submenu toggle
  document.addEventListener(
    'click',
    (e) => {
      const link = e.target.closest(
        '.sidebar--dompet .metismenu > li > a.has-arrow'
      );
      if (!link) return;

      const li = link.closest('li');
      if (!li) return;

      e.preventDefault();
      e.stopPropagation();

      // Collapsed desktop: open as popup
      if (isCollapsedDesktop()) {
        const already = li.classList.contains('popup-open');
        document
          .querySelectorAll('.sidebar--dompet li.popup-open')
          .forEach((x) => x.classList.remove('popup-open'));

        if (!already) {
          setPopupPos(li);
          li.classList.add('popup-open');
        }
        return;
      }

      // Normal: toggle inline submenu
      const isOpen = li.classList.toggle('is-open');
      link.setAttribute('aria-expanded', isOpen ? 'true' : 'false');

      const ul = li.querySelector(':scope > ul.mm-collapse');
      if (ul) ul.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
    },
    true
  );

  // Hover popup (collapsed desktop)
  let hoverTimer = null;

  document.addEventListener(
    'mouseenter',
    (e) => {
      const li = e.target.closest(
        '.sidebar--dompet .metismenu > li[data-has-sub="1"]'
      );
      if (!li || !isCollapsedDesktop()) return;

      clearTimeout(hoverTimer);
      document
        .querySelectorAll('.sidebar--dompet li.popup-open')
        .forEach((x) => x.classList.remove('popup-open'));

      setPopupPos(li);
      li.classList.add('popup-open');
    },
    true
  );

  document.addEventListener(
    'mouseleave',
    (e) => {
      const li = e.target.closest(
        '.sidebar--dompet .metismenu > li[data-has-sub="1"]'
      );
      if (!li || !isCollapsedDesktop()) return;

      clearTimeout(hoverTimer);
      hoverTimer = setTimeout(() => li.classList.remove('popup-open'), 180);
    },
    true
  );

  // Profile dropdown (data-hp-menu)
  document.addEventListener(
    'click',
    (e) => {
      const trigger = e.target.closest('.sidebar--dompet [data-hp-menu]');
      const profile = e.target.closest('.sidebar--dompet .header-profile');

      if (trigger && profile) {
        e.preventDefault();
        e.stopPropagation();

        const isOpen = profile.classList.toggle('is-open');
        trigger.setAttribute('aria-expanded', isOpen ? 'true' : 'false');

        const menu = profile.querySelector('.hp-menu');
        if (menu) {
          if (isOpen) {
            const anchor = profile.querySelector('.hp-trigger') || trigger;
            const r = anchor.getBoundingClientRect();

            // fixed agar tidak ke-clip overflow hidden
            menu.style.position = 'fixed';
            menu.style.left = Math.round(r.left + 8) + 'px';
            menu.style.top = Math.round(r.bottom + 8) + 'px';
            menu.style.width = Math.max(240, Math.round(r.width)) + 'px';
            menu.style.zIndex = '9999';
            menu.setAttribute('aria-hidden', 'false');
          } else {
            menu.removeAttribute('style');
            menu.setAttribute('aria-hidden', 'true');
          }
        }
        return;
      }

      // klik luar: tutup dropdown profile
      document.querySelectorAll('.sidebar--dompet .header-profile.is-open').forEach((el) => {
        if (!el.contains(e.target)) {
          el.classList.remove('is-open');
          el.querySelector('[data-hp-menu]')?.setAttribute('aria-expanded', 'false');
          el.querySelector('.hp-menu')?.removeAttribute('style');
          el.querySelector('.hp-menu')?.setAttribute('aria-hidden', 'true');
        }
      });

      // klik luar sidebar saat collapsed: tutup popup submenu
      if (isCollapsedDesktop()) {
        const insideSidebar = e.target.closest('.sidebar--dompet');
        if (!insideSidebar) {
          document
            .querySelectorAll('.sidebar--dompet li.popup-open')
            .forEach((li) => li.classList.remove('popup-open'));
        }
      }
    },
    true
  );

  // Coming soon
  document.addEventListener(
    'click',
    (e) => {
      const soon = e.target.closest('.sidebar--dompet [data-coming-soon="1"]');
      if (!soon) return;
      e.preventDefault();
      alert('Coming soon 🙂');
    },
    true
  );

  // Resize normalize (mobile never collapsed)
  window.addEventListener('resize', () => {
    if (!isDesktop()) {
      body.classList.remove('sidebar-collapsed');
    } else {
      if (localStorage.getItem(KEY) === '1') body.classList.add('sidebar-collapsed');
    }

    closeMobile();
    document
      .querySelectorAll('.sidebar--dompet li.popup-open')
      .forEach((li) => li.classList.remove('popup-open'));
  });
})();
