<?php
declare(strict_types=1);

date_default_timezone_set('Asia/Jakarta');

define('BASE_PATH', dirname(__DIR__));
define('APP_PATH', BASE_PATH . '/app');
define('PUBLIC_PATH', __DIR__);
define('STORAGE_PATH', BASE_PATH . '/storage');
define('ASSETS_PATH', BASE_PATH . '/assets');

// session (Sprint 1 foundation)
if (session_status() !== PHP_SESSION_ACTIVE) {
  session_start();
}
// fallback sementara sampai auth/login jadi
$_SESSION['tenant_id'] = $_SESSION['tenant_id'] ?? 1;
$_SESSION['location_id'] = $_SESSION['location_id'] ?? 1;

// basic error handling -> storage/logs
ini_set('display_errors', '0');
error_reporting(E_ALL);

set_exception_handler(function(Throwable $e){
  $dir = STORAGE_PATH . '/logs';
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $msg = "[".date('Y-m-d H:i:s')."] EXCEPTION: ".$e->getMessage()." in ".$e->getFile().":".$e->getLine()."\n".$e->getTraceAsString()."\n\n";
  @file_put_contents($dir.'/app.log', $msg, FILE_APPEND);
  http_response_code(500);
  echo "Internal Server Error";
});

set_error_handler(function($severity, $message, $file, $line){
  $dir = STORAGE_PATH . '/logs';
  if (!is_dir($dir)) @mkdir($dir, 0775, true);
  $msg = "[".date('Y-m-d H:i:s')."] ERROR: ".$message." in ".$file.":".$line."\n\n";
  @file_put_contents($dir.'/app.log', $msg, FILE_APPEND);
  return true;
});

require_once APP_PATH . '/config/app.php';
require_once APP_PATH . '/helpers/url_helper.php';
require_once APP_PATH . '/helpers/db.php';
require_once APP_PATH . '/helpers/auth_helper.php';
require_once APP_PATH . '/helpers/sidebar_helpers.php';
require_once APP_PATH . '/models/LocationIdentity.php';
require_once APP_PATH . '/services/IdentityService.php';


// Simple view renderer
function view(string $path, array $data = []): void {
  extract($data);
  require APP_PATH . '/views/' . ltrim($path, '/');
}

// Load routes
require_once APP_PATH . '/routes/web.php';
